( function () {
	tinymce.PluginManager.add( 'swp_shortcode_generator', function ( b, a ) {
		b.addButton( 'swp_shortcode_generator', {
			title: 'Social Warfare Buttons',
			icon: 'sw sw sw-social-warfare',
			onclick() {
				b.windowManager.open( {
					title: 'Insert Social Warfare Buttons',
					body: [
						{
							type: 'listbox',
							name: 'reflection',
							label: 'Should the buttons reflect this post or another one?',
							values: [
								{ text: 'This Post', value: 'default' },
								{ text: 'A Different Post', value: 'alt' },
							],
							onselect( c ) {
								if ( this.value() == 'alt' ) {
									jQuery( '.mce-postid' )
										.parent()
										.parent()
										.slideDown();
								} else {
									jQuery( '.mce-postid' )
										.parent()
										.parent()
										.slideUp();
								}
							},
						},
						{
							type: 'textbox',
							multiline: false,
							name: 'postID',
							classes: 'postid',
							label: 'The ID of the post or page to reflect:',
						},
						{
							type: 'textbox',
							multiline: false,
							name: 'buttons',
							classes: 'buttons',
							label: 'Buttons to Include:',
						},
						{
							type: 'label',
							name: 'someHelpText',
							onPostRender() {
								this.getEl().innerHTML =
									'<span style="float:right;">Comma separated list of social network (e.g. "Facebook,Twitter,Total"). Leave blank to use site-wide defaults.</span>';
							},
							text: '',
						},
					],
					onPostRender() {
						jQuery( '.mce-postid' ).parent().parent().slideUp();
						jQuery( '.mce-title' ).prepend(
							'<i class="sw sw-social-warfare"></i>'
						);
					},
					onsubmit( d ) {
						if (
							d.data.reflection == 'alt' &&
							d.data.postID != ''
						) {
							var f = ' post_id="' + d.data.postID + '"';
						} else {
							var f = '';
						}
						if ( d.data.buttons != '' ) {
							var c = ' buttons="' + d.data.buttons + '"';
						} else {
							var c = '';
						}
						b.insertContent( '[social_warfare' + f + '' + c + ']' );
					},
				} );
			},
		} );
	} );
} )();
